import os, datetime, subprocess, shlex, time, logging

class Volet:
	"""Classe definissant un volet caracterise par :
	- son nom
	- son adresse sur le bus
	- son numero sur le bus, 0 ou 1
	- son etat actuel
	- son etat inverse par rapport au statut
	- son etat inverse de sa commande"""


	def __init__(self, nom, adresse, numero, inverseStatut, inverseCommande):
		"""Constructeur de notre classe"""
		self.nom = nom
		self.adresse = adresse
		self.numero = int(numero)
		self.etat = "undefined"
		self.inverseStatut = inverseStatut
		self.inverseCommande = inverseCommande
		logging.basicConfig(filename='volets.log',level=logging.DEBUG)

	def ToString(self):
		timeDisplay = "{:%d/%m/%Y %H.%M.%S}".format(datetime.datetime.now())
		return "[{}] {} ({}/{}/{}/{}) : {}".format(timeDisplay, self.nom, self.adresse, self.numero, str(self.inverseStatut), str(self.inverseCommande), self.etat)

	def Print(self):
		print self.ToString()
		
	def GetStatut(self):	
		scale = 16 ## equals to hexadecimal
		num_of_bits = 4
		f = os.popen('i2cget -y 1 %s' % self.adresse, 'r')
		retour = f.read()
		
		rc = f.close()
		if rc is not None and rc >> 8:
			#print "There were some errors"
			pass
		else:
			# Statut sous forme "1001"
			statut = bin(int(retour, scale))[2:].zfill(num_of_bits)
			# 10 => Volet 1
			# 01 => Volet 2

			valeur = ""		
			if self.numero==0:
				# Le premier volet
				valeur = statut[:2]
			else:
				# Le second volet
				valeur = statut[2:]

			if valeur[:1] == "0":
				return "Arret"
			else:
				if valeur[1:] == "0":
					if self.inverseStatut:
						return "Montee"
					else:
						return "Descente"
				else:
					if self.inverseStatut:
						return "Descente"
					else:
						return "Montee"
	

	def Close(self):	
		self.ChangeState("Descente")

	def Open(self):	
		self.ChangeState("Montee")

	def Stop(self):	
		self.ChangeState("Arret")
	
	def ChangeState(self, action):
		b1 = 0
		b2 = 0
		b3 = 0
		
		b1 = self.numero

		if action == "Arret":
			b2 = 0
		else:
			b2 = 1
		
		if action == "Montee":
			if self.inverseCommande:
				b3 = 0
			else:
				b3 = 1
		else:
			if self.inverseCommande:
				b3 = 1
			else:
				b3 = 0
		
		#cmd = "%s%s%s" % (b1, b2, b3)
		i = (b1*4) + (b2*2) + b3
		print("cmd : %s = %x" % (bin(i), i))
		
		commande = 'i2cset -y 1 %s 0x%x' % (self.adresse, i)
		
		
		# Boucle de rejeu en cas d'echec.
		succes = False
		while True:
			print ("-----------------------------------")
			print ("Commande I2CSET : %s" % commande)		
			logging.debug("Commande I2CSET : %s" % commande)			
			p = os.system(commande)
			
			
			if p == 0:
				succes = True
			else:
				succes = False
				time.sleep(0.1)
				
			if succes: break